(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40119,       1127]*)
(*NotebookOutlinePosition[     40847,       1152]*)
(*  CellTagsIndexPosition[     40803,       1148]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Transformada de Fourier Discreta Bidimensional. Filtrado en frecuencia.\
\>", "Title"],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell["\<\
Los siguientes comandos cargan todos los paquetes gr\[AAcute]ficos y \
establecen opciones por defecto para algunos comandos que usaremos en este \
cuaderno.\
\>", "Text"],

Cell[BoxData[{
    \(\(<< Graphics`;\)\), "\[IndentingNewLine]", 
    \(<< LinearAlgebra`MatrixManipulation`\), "\[IndentingNewLine]", 
    \(\(SetOptions[ListDensityPlot, Mesh \[Rule] False, Frame \[Rule] False, 
        AspectRatio \[Rule] Automatic];\)\), "\[IndentingNewLine]", 
    \(\(SetOptions[ListPlot3D, 
        Mesh \[Rule] False];\)\), "\[IndentingNewLine]", 
    \(\(SetOptions[Fourier, 
        FourierParameters \[Rule] {\(-1\), \(-1\)}];\)\), \
"\[IndentingNewLine]", 
    \(\(SetOptions[InverseFourier, 
        FourierParameters \[Rule] {\(-1\), \(-1\)}];\)\), \
"\[IndentingNewLine]", 
    \( (*\ \(Off[General::"\<spell1\>"];\)*) \)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetDirectory["\<D:/Trabajo/02_Docencia \
Informatica/Ingenieria_Informatica/Curso2006_2007/Calculo \
Avanzado/practicas/06_imagenes/\>"];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformada de Fourier Discreta bidimensional", "Section"],

Cell[TextData[{
  "La Transformada de Fourier Discreta en dos dimensiones (2D-DFT) de una \
matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "=", \(\((f(m, n))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  " donde",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(0 \[LessEqual] m \[LessEqual] 
        M - 1\)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] n \[LessEqual] N - 1\)]],
  " es la matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["f",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \(\((F(p, q))\)\_\(M\[Times]N\)\)}]}], 
        TraditionalForm]]],
  " donde",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(0 \[LessEqual] p \[LessEqual] M - 1\ , 
      0 \[LessEqual] q \[LessEqual] \(\(N\)\(-\)\(1\)\(\ \)\)\)\)\)]],
  "(ambas matrices se consideran en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^\(M\[Times]N\)\)]],
  ") cuyos elementos vienen dados por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            FormBox[
              RowBox[{\(F(p, q)\), "=", 
                RowBox[{\(1\/\(M\ N\)\), 
                  RowBox[{
                    UnderoverscriptBox[
                      StyleBox["\[Sum]",
                        FontSize->8], \(m = 0\), \(M - 
                        1\)], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(n = 
                            0\)\%\(N - 1\)\) \(f(m, 
                        n)\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \(\
\[Pi](\ \(m\ p\)\/M + \(n\ q\)\/N)\)\)\)\(\ \ \ \ \ \ \ \ \ \ \ \)\((\ 
                        0 \[LessEqual] p \[LessEqual] M - 1\ , 
                        0 \[LessEqual] q \[LessEqual] N - 1)\)\(\ \)\)}]}]}],
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Como las igualdades (1) tienen perfecto sentido para enteros cualesquiera \
",
  Cell[BoxData[
      \(TraditionalForm\`p, q \[Element] \[DoubleStruckCapitalZ]\)]],
  " y, en virtud de la periodicidad de la exponencial compleja, se verifica \
que ",
  Cell[BoxData[
      \(TraditionalForm\`F(p + M, q + N) = F(p, q)\)]],
  ", en la teor\[IAcute]a de la 2D-DFT se interpreta siempre la se\[NTilde]al \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["f",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \(\((F(p, q))\)\_\(M\[Times]N\)\)}]}], 
        TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["como una se\[NTilde]al discreta en el espacio de la frecuencia y \
doblemente peri\[OAcute]dica con per\[IAcute]odos ",
    FontWeight->"Bold"],
  StyleBox["M",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" y ",
    FontWeight->"Bold"],
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", esto es, ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(F(p + M, q + N) = F(p, q)\),
            "TraditionalForm"]}], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" para todos ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`p, q \[Element] \[DoubleStruckCapitalZ]\)],
    FontWeight->"Bold"],
  ". Los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`1/M\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`1/N\)]],
  " son la",
  StyleBox[" frecuencia fundamental",
    FontWeight->"Bold"],
  " ",
  StyleBox["horizontal y vertical",
    FontWeight->"Bold"],
  " respectivamente en (1)."
}], "Text"],

Cell["A su vez la se\[NTilde]al original se puede expresar en la forma", \
"Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            FormBox[
              RowBox[{\(f(m, n)\), "=", 
                RowBox[{
                  UnderoverscriptBox[
                    StyleBox["\[Sum]",
                      FontSize->8], \(p = 0\), \(M - 
                      1\)], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(q = 
                          0\)\%\(N - 1\)\) \(F(p, 
                      q)\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \(\[Pi](\ \
\(m\ p\)\/M + \(n\ q\)\/N)\)\)\)\(\ \ \ \ \ \ \ \ \ \ \ \)\((\ 
                      0 \[LessEqual] m \[LessEqual] M - 1\ , 
                      0 \[LessEqual] n \[LessEqual] N - 1)\)\(\ \)\)}]}],
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Como las igualdades (2) tienen perfecto sentido para cualesquiera enteros \
",
  Cell[BoxData[
      \(TraditionalForm\`m, n \[Element] \[DoubleStruckCapitalZ]\)]],
  " y se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`f(m + M, n + N) = f(m, n)\)]],
  ", en la teor\[IAcute]a de la DFT se interpreta siempre la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "=", \(\((f(m, n))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["como una se\[NTilde]al discreta en el dominio espacial y \
doblemente peri\[OAcute]dica con per\[IAcute]odos ",
    FontWeight->"Bold"],
  StyleBox["M",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" y ",
    FontWeight->"Bold"],
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", esto es, ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(f(m + M, n + N) = f(m, n)\),
            "TraditionalForm"]}], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" para todos ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`m, n \[Element] \[DoubleStruckCapitalZ]\)],
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[TextData[{
  "Consecuencia inmediata de las igualdades (1) y (2) es que la DFT es una \
biyecci\[OAcute]n lineal de  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^\(M\[Times]N\)\)]],
  " sobre  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^\(M\[Times]N\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Transformada simb\[OAcute]lica 2D-DFT", "Subsection"],

Cell[TextData[{
  "Es f\[AAcute]cil definir un comando que calcule simb\[OAcute]licamente la \
2D-DFT de una matriz. Para ello es conveniente escribir la igualdad (1) de \
forma que se adapte mejor a la notaci\[OAcute]n de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            FormBox[
              RowBox[{\(F(p, q)\), "=", 
                RowBox[{\(1\/\(M\ N\)\), 
                  RowBox[{
                    UnderoverscriptBox[
                      StyleBox["\[Sum]",
                        FontSize->8], \(m = 1\), 
                      "M"], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(n = 
                            1\)\%N\) \(f(m, 
                        n)\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \(\
\[Pi](\ \(\((m - 1)\) \((p - 1)\)\)\/M + \(\((n - 1)\) \((q - \
1)\)\)\/N)\)\)\)\(\ \ \ \ \ \ \ \ \ \ \ \)\((\ 
                        1 \[LessEqual] p \[LessEqual] M\ , 
                        1 \[LessEqual] q \[LessEqual] N)\)\(\ \)\)}]}]}],
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Observamos que cada elemento ",
  Cell[BoxData[
      \(TraditionalForm\`F(p, q)\)]],
  " se obtiene multiplicando elemento a elemento la ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(matriz\)\(\ \)\(\((f(m, n))\)\_\(M\[Times]
              N\)\)\(\ \)\)\)]],
  "por la matriz compleja conjugada de ",
  Cell[BoxData[
      \(TraditionalForm\`W\_\((p, q)\) = \(1\/\(M\ N\)\) \((Exp(\(\((m - 1)\) \
\((p - 1)\)\)\/M, \(\((n - 1)\) \((q - 1)\)\)\/N))\)\_\(1 \[LessEqual] m \
\[LessEqual] M, 1 \[LessEqual] n \[LessEqual] N\)\)]],
  " y sumando todos los elementos de la matriz resultante."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "a) Define las matrices \"W[p,q,M,N]\" y un comando \"dft2Dmtrx[matriz ]\" \
que calcule simb\[OAcute]licamente la 2D-DFT de una matriz. \nEl comando de \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Fourier[ ] calcula transformadas de Fourier discretas de listas anidadas \
de cualquier dimensi\[OAcute]n. En particular calcula  la 2D-DFT, es decir, \
la transformada de Fourier discreta de una matriz. Es un comando que solo \
trabaja num\[EAcute]ricamente. \nGenera aleatoriamente una matriz (no muy \
grande) y ",
  "comprueba que tu comando proporciona igual resultado que el comando",
  " Fourier[ ] de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\nb) Convierte las matrices \"W[p,q,M,N]\" en vectores y comprueba que \
forman una base ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[DoubleStruckCapitalC]\^\(M\[Times]
            N\)\)\(\ \)\)\)]],
  "(hazlo para ",
  Cell[BoxData[
      \(TraditionalForm\`M = \(N = 3\)\)]],
  ").\nc) Define un comando \"dft2Dvector[matriz]\" que calcule la 2D-DFT de \
una matriz trat\[AAcute]ndola como un vector. Genera aleatoriamente una \
matriz (no muy grande) y comprueba que tu comando proporciona igual resultado \
que el comando Fourier[ ] de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformada num\[EAcute]rica 2D-DFT", "Subsection"],

Cell[TextData[{
  "Una propiedad muy \[UAcute]til de la 2D-DFT es que es separable, esto es, \
puede calcularse en dos etapas haciendo sucesivas 1D-DFT. Para ello, basta \
notar que calculando las transformadas 1D-DFT de las filas de la matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "=", \(\((f(m, n))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  " obtenemos una matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Z",
            FontWeight->"Bold"], "=", \((Z(m, q))\), " "}], 
        TraditionalForm]]],
  " cuyos elementos viene dados por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            
            FormBox[\(Z(m, 
                  q) = \(\(1\/\(\(N\)\(\ \)\)\) \(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \
\)\)\)\+\(n = 0\)\%\(N - 1\)\) \(f(m, 
                    n)\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi] \( \
n\ q\)\/N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \)\((\ 
                    0 \[LessEqual] m \[LessEqual] M - 1\ , 
                    0 \[LessEqual] q \[LessEqual] N - 1)\)\(\ \)\)\),
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell["\<\
Y calculando las 1D-DFT de las columnas de esta matriz obtenemos la 2D-DFT de \
la matriz inicial.\
\>", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            RowBox[{\(1\/\(\(M\)\(\ \)\)\), 
              RowBox[{
                UnderoverscriptBox[
                  StyleBox["\[Sum]",
                    FontSize->8], \(m = 0\), \(M - 1\)], \(\(Z(m, 
                    q)\)\ \ \ \[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi] \
\( m\ p\)\/M\)\)}]}],
            FontWeight->"Bold"], 
          StyleBox["    ",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[
              FormBox[
                RowBox[{
                  RowBox[{\(1\/\(M\ N\)\), 
                    RowBox[{
                      UnderoverscriptBox[
                        StyleBox["\[Sum]",
                          FontSize->8], \(m = 0\), \(M - 
                          1\)], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(n = 
                              0\)\%\(N - 1\)\) \(f(m, 
                          n)\) \[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \(\
\[Pi](\ \(m\ p\)\/M + \(n\ q\)\/N)\)\)\)}]}], "   ", "="}],
                "TraditionalForm"],
              FontWeight->"Bold"], 
            StyleBox["   ",
              FontWeight->"Bold"], 
            StyleBox[\(F(p, q)\),
              FontWeight->"Bold"], "          "}]}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "a) Define un comando \"dft2D[matriz]\" que calcule num\[EAcute]ricamente \
la 2D-DFT de una matriz. Genera aleatoriamente una matriz 256\[Times]256 y \
comprueba que tu comando proporciona igual resultado que el comando Fourier[ \
] de ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " \nb) Usando el comando \"Timing[ ]\", compara la eficacia de los tres \
comandos que has definido con el comando Fourier[ ] de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Usa matrices generadas aleatoriamente de tama\[NTilde]o 1024\[Times]1024 \
para los comandos num\[EAcute]ricos y de tama\[NTilde]o 16\[Times]16 para los \
simb\[OAcute]licos."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Propiedades de simetr\[IAcute]a de la 2D-DFT", "Subsection"],

Cell[TextData[{
  "Teniendo en cuenta las propiedades de simetr\[IAcute]a de la 1D-DFT se \
deduce que la 2D-DFT de una ",
  StyleBox["matriz real",
    FontWeight->"Bold"],
  " es ",
  StyleBox["hemisim\[EAcute]trica",
    FontWeight->"Bold"],
  " respecto del valor ",
  Cell[BoxData[
      \(TraditionalForm\`F(M/2, N/2)\)]],
  ", esto es el valor que ocupa el lugar \"central\" ",
  Cell[BoxData[
      \(TraditionalForm\`\((M/2 + 1, N/2 + 1)\)\)]],
  ", siendo ",
  StyleBox["M\[Times]N",
    FontSlant->"Italic"],
  "  las dimensiones de la matriz que se suponen pares. Es decir, para se\
\[NTilde]ales reales, se verifica qe   "
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[\(\(\ \)\(F(M/2 + p, N/2 + q) = \(F\&__\)(M/2 - p, 
            N/2 - q)\)\),
        FontWeight->"Bold"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde la barrita en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(F\&__\)\(\ \ \)\)\)]],
  "indica complejo conjugado. El convenio de iniciar los \[IAcute]ndices en 0 \
puede llevar a error pues ",
  Cell[BoxData[
      \(TraditionalForm\`F(M/2, N/2)\)]],
  " ocupa el lugar \"central\"  ",
  Cell[BoxData[
      \(TraditionalForm\`\((M/2 + 1, N/2 + 1)\)\)]],
  " en la transformada, es decir, en la notaci\[OAcute]n de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la simetr\[IAcute]a se expresa en la forma"
}], "Text"],

Cell[TextData[{
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{\([\([M/2 + 1 + k, N/2 + 1 + j]\)]\), "=", 
            RowBox[{
              StyleBox[\(F\&__\),
                FontWeight->"Bold"], 
              FormBox[\([\([M/2 + 1 - k, N/2 + 1 - j]\)]\),
                "TraditionalForm"]}]}]}], TraditionalForm]],
    FontWeight->"Bold"]
}], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Por ello es costumbre centrar la 2D-DFT de forma que el t\[EAcute]rmino ",
  Cell[BoxData[
      \(TraditionalForm\`F(0, 0)\)]],
  " ocupe en la matriz transformada el lugar ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \ \)\(\((M/2 + 1, 
          N/2 + 1)\)\(\ \)\(.\)\)\)\)]],
  " El siguiente comando hace esta operaci\[OAcute]n."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando \"centrar[matriz]\" que al actuar sobre una matriz ",
  Cell[BoxData[
      \(TraditionalForm\`S = \((s(i, j))\)\_\(M\[Times]N\)\)]],
  " proporcione otra ",
  Cell[BoxData[
      \(TraditionalForm\`T = \((t(i, j))\)\)]],
  " de iguales dimensiones (que suponemos pares) de forma que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(t(M/2 + 1, N/2 + 1)\)\(=\)\(s(1, 
          1)\)\(\ \)\)\)]],
  "y se conserve el orden relativo c\[IAcute]clico de los elementos de la \
matriz ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Te sugiero que uses el comando RotateRight[ ] de forma apropiada.\nb) \
Comprueba la propiedad de hemisimetr\[IAcute]a de la 2D-DFT con una matriz \
256\[Times]256 generada aleatoriamente. Debes comprobar la igualdad (6) para \
todos los elementos de la transformada la cual deber\[AAcute]s centrar \
previamente. Un While[] subordinado a un For[ ] es lo apropiado.\nc) \
Comprueba con una matriz 256\[Times]256 generada aleatoriamente que se \
consigue el mismo efecto de centrar la 2D-DFT si  antes de calcular la \
transformada  multiplicas cada elemento ",
  Cell[BoxData[
      \(TraditionalForm\`f(m, n)\)]],
  " de la imagen por ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\))\)\^\(m + n\)\)]],
  ". \[DownQuestion]Sabr\[IAcute]as explicar por qu\[EAcute]? Sugerencia: El \
comando \"Normal[SparseArray[ ]]\" puede ser \[UAcute]til. Consulta la \
ayuda."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Espectros de amplitudes de algunas se\[NTilde]ales senoidales elementales\
\>", "Section"],

Cell["\<\
Es costumbre llamar a la transformada 2D-DFT de una se\[NTilde]al \
bidimensional el espectro de la se\[NTilde]al y a sus elementos coeficientes \
espectrales. El espectro de amplitudes es la matriz formada por los \
m\[OAcute]dulos de los elementos del espectro (es una matriz \
sim\[EAcute]trica respecto del lugar central (M/2+1,N/2+1)) y el espectro de \
fases es la matriz formada por los argumentos de los elementos del espectro. \
Podemos representar con ListDensityPlot[ ] los espectros de amplitudes y de \
fases de una imagen. \
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell["\<\
a) Define un comando \"muestra[func,razonmuestreo,tiempo]\" que muestrea una \
funci\[OAcute]n de dos variables con una raz\[OAcute]n de muestreo (la misma \
en las direcciones horizontal y vertical) durante cierto tiempo (la salida de \
este comando ser\[AAcute] una matriz cuadrada). Puedes empezar a muestrear a \
partir del valor inicial (x,y)=(0,0).
b) Define un comando \"espectrumPlot[func,razonmuestreo,tiempo]\" que \
proporciona las im\[AAcute]genes de la muestra obtenida con el anterior \
comando y de su espectro de amplitudes (centrado). Para aumentar el rango din\
\[AAcute]mico del espectro de amplitudes se representa con ListDensityPlot[ ] \
la matriz 0.5Log[1+espectroamplitudes].
c) La siguiente funci\[OAcute]n \"onda[ ]\" es una sinusoide con una \
\[UAcute]nica frecuencia igual a 32 hercios en la direcci\[OAcute]n \
horizontal y amplitud 10. Representa la imagen obtenida por muestreo de la se\
\[NTilde]al y su espectro de amplitudes.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(\(onda[x_, y_] = 10  Cos[32\ 2\ Pi\ y]\ ;\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[onda, 128, 1]\)}], "Input"],

Cell["\<\
Observa que en el espectro de amplitudes se aprecian solamente dos puntitos \
blancos que son los \[UAcute]nicos valores positivos del mismo y que \
representan la \[UAcute]nica frecuencia presente en la muestra. Veamos en d\
\[OAcute]nde est\[AAcute]n los dos \[UAcute]nicos valores positivos del \
espectro.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(\(dftimg = 
        centrar[Abs[
            Chop[Fourier[
                muestra[onda, 128, 1]]]]];\)\), "\[IndentingNewLine]", 
    \({Select[Flatten[dftimg], Positive], Position[dftimg, _?\((# > 0 &)\)]} // 
      Transpose\)}], "Input"],

Cell["\<\
Observamos que est\[AAcute]n en la fila central (la fila 65) en las columnas \
33=65-32 y 97=65+32 por lo que son sim\[EAcute]tricos respecto al centro de \
la fila. Adem\[AAcute]s, su valor es igual a 5 que es la mitad de la amplitud \
de la se\[NTilde]al muestreada.\
\>", "ExerciseText"],

Cell["\<\
Repite lo anterior con las siguientes se\[NTilde]ales e interpreta los \
resultados que obtienes. \
\>", "ExerciseText"],

Cell[BoxData[
    \(\(\( (*se\[NTilde]al\ sinusoidal\ con\ frecuencia\ solamente\ en\ la\ \
direcci\[OAcute]n\ vertical*) \)\(\[IndentingNewLine]\)\(\(onda[x_, y_] = 
        10  Cos[32\ 2\ Pi\ x];\)\[IndentingNewLine]
    espectrumPlot[onda, 128, 1]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*frecuencia\ solamente\ en\ la\ direcci\[OAcute]n\ de\ la\ \
bisectriz\ del\ primer\ cuadrante*) \)\(\[IndentingNewLine]\)\(\(onda[x_, 
          y_] = 10  Cos[2\ Pi \((32\ x + 32\ y)\)]\ ;\)\[IndentingNewLine]
    espectrumPlot[onda, 128, 1]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*una\ se\[NTilde]al\ m\[AAcute]s\ compleja*) \)\(\
\[IndentingNewLine]\)\(\(onda[x_, y_] = 
        10  Cos[2\ Pi\ \((12  x\  + \ 58\ y)\)] + \ 
          8  Cos[2\ Pi \((32\ x\  + \ 8\ y)\)]\ ;\)\[IndentingNewLine]
    espectrumPlot[onda, 128, 1]\)\)\)], "Input"],

Cell["\<\
Ahora ya debes saber el lugar que ocupan en el espectro de amplitudes los \
coeficientes que corresponden a una componente senoidal del tipo ACos[p 2 Pi \
x + q 2 Pi y] (son los que representan las frecuencias (p,q)). \
\[DownQuestion]A qu\[EAcute] distancia (distancia eucl\[IAcute]dea) del \
centro de la transformada se encuentran? \[DownQuestion]D\[OAcute]nde ser \
representan en la transformada las frecuencias m\[AAcute]s bajas? \
\[DownQuestion]Y las frecuencias m\[AAcute]s altas?\
\>", "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtrado de im\[AAcute]genes en el dominio de la frecuencia", "Section"],

Cell[TextData[{
  "Consideremos una imagen digitalizada ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "=", \(\((f(m, n))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  ". La estrategia b\[AAcute]sica para dise\[NTilde]ar filtros en frecuencia \
consta de tres pasos:\n1 Obtener la 2D-DFT centrada de la imagen: ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["f",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \(\((F(p, q))\)\_\(M\[Times]N\)\)}]}], 
        TraditionalForm]]],
  ".\n2 Definir la ",
  StyleBox["funci\[OAcute]n de transferencia",
    FontWeight->"Bold"],
  " del filtro ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["H",
            FontWeight->"Bold"], "=", \(\((h(p, q))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  " (conviene que sea sim\[EAcute]trica respecto al lugar central).\n3 \
Calcular (la parte real de) la 2D-DFT inversa del producto t\[EAcute]rmino a \
t\[EAcute]rmino de ",
  StyleBox["F ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "por ",
  StyleBox["H",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y revertir el proceso de centrado."
}], "Text"],

Cell[TextData[{
  "Estas operaciones se corresponden con una convoluci\[OAcute]n \
c\[IAcute]clica en el dominio espacial. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcula la convoluci\[OAcute]n c\[IAcute]clica de dos matrices con el \
comando ListConvolve[matriz1,matriz2,1]. La propiedad fundamental de la \
2D-DFT es que transforma la convoluci\[OAcute]n c\[IAcute]clica de dos \
matrices de iguales dimensiones en el producto matricial t\[EAcute]rmino a t\
\[EAcute]rmino de las transformadas. "
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[ScriptCapitalF][matriz1\[SixPointedStar]matriz2] = 
      N\ M\ \[ScriptCapitalF][matriz1] \[ScriptCapitalF][matriz2]\)],
  FontWeight->"Bold"]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Hay que multiplicar por el factor ",
  Cell[BoxData[
      \(TraditionalForm\`N\ M\)]],
  " (producto de las dimensiones de las matrices) debido a los \
par\[AAcute]metros que usamos en el comando Fourier. Si us\[AAcute]ramos la \
opci\[OAcute]n por defecto de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no ser\[IAcute]a preciso hacer este ajuste. A efectos de representaci\
\[OAcute]n gr\[AAcute]fica de una imagen se trata de un ajuste innecesario."
}], "Text"],

Cell[BoxData[{
    \(\(a = Table[Random[], {i, 24}, {j, 12}];\)\), "\[IndentingNewLine]", 
    \(\(b = Table[Random[], {i, 24}, {j, 12}];\)\), "\[IndentingNewLine]", 
    \(\(c = ListConvolve[a, b, 1];\)\), "\[IndentingNewLine]", 
    \(Simplify[
      Chop[Fourier[c] - 24*12  Fourier[a]*Fourier[b]] \[Equal] 0]\)}], "Input"],

Cell[TextData[{
  "Deducimos que el filtrado en frecuencia se corresponde con una convoluci\
\[OAcute]n en el dominio espacial. Pues llamando ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["h",
            FontWeight->"Bold"], "=", \(\((h(p, q))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  " a la 2D-DFT inversa de la funci\[OAcute]n de transferencia ",
  StyleBox["H",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", se tiene que:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`F\ H = \(\(\[ScriptCapitalF](f)\) \(\[ScriptCapitalF](
            h)\) = \(\(1\/MN\) \(\[ScriptCapitalF](
                f\[SixPointedStar]\ h)\)\ \ \ \[DoubleLongRightArrow]
              f\[SixPointedStar]\ h = \(\(M\)\(\ \)\(N\)\(\ \)\(\(\
\[ScriptCapitalF]\^\(-1\)\)(F\ H)\)\(\ \)\)\)\)\)]]], "Text",
  TextAlignment->Center,
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[TextData[{
  "Es decir, la imagen que recuperamos despu\[EAcute]s del proceso de \
filtrado en frecuencia, es la misma que obtendr\[IAcute]amos realizando una \
convoluci\[OAcute]n c\[IAcute]clica de la imagen inicial con la \
funci\[OAcute]n ",
  StyleBox["h",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que se llama ",
  StyleBox["funci\[OAcute]n impulsiva",
    FontWeight->"Bold"],
  " del correspondiente filtro espacial. Es importante observar que para que \
la funci\[OAcute]n ",
  StyleBox["h",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " sea real es preciso que la funci\[OAcute]n de transferencia ",
  StyleBox["H sea sim\[EAcute]trica respecto al lugar central (M/2+1,N/2+1).",
    
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " \nLo que acabamos de ver explica por qu\[EAcute] el dominio de la \
frecuencia suele proporcionar m\[EAcute]todos sencillos de realizar \
operaciones que no son f\[AAcute]ciles de implementar directamente en el \
dominio espacial. "
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "a) Define un comando \
\"filtrogeneral[imagen_?MatrixQ,filtro_?MatrixQ,opts___]\" donde se supone \
que su primer argumento es una matriz (imagen inicial) y el segundo es la \
funci\[OAcute]n de transferencia ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "de un filtro, que se supone conocida y que debe ser una matriz de iguales \
dimensiones que la imagen. La salida del comando deben ser la gr\[AAcute]fica \
de la imagen despu\[EAcute]s de ser sometida al proceso de filtrado antes \
descrito. Las opciones opt___ se las pasamos al comando ListDensityPlot[  ].\n\
Observaci\[OAcute]n. Para revertir el proceso de centrado se multiplica por \
",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\))\)\^\(m + n\)\)]],
  " como antes se ha indicado. Por si el filtro usado no fuera \
sim\[EAcute]trico debes tomar parte real antes de usar ListDensityPlot[ ]."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtros de paso bajo y paso alto", "Subsection"],

Cell["\<\
Las frecuencias bajas en la 2D-DFT de una imagen se corresponden con zonas \
homog\[EAcute]neas de la imagen con niveles de gris uniforme, mientras que \
las frecuencias altas est\[AAcute]n relacionadas con los perfiles y detalles \
en los que se producen bruscos cambios de luminosidad, lo que tambi\[EAcute]n \
puede ser debido al posible ruido que pueda tener la imagen. Como su nombre \
indica, un filtro de paso bajo solamente deja pasar las frecuencias bajas, \
por lo que su resultado es que los perfiles se muestran borrosos y la imagen \
obtenida est\[AAcute] formada por planos con tonalidades de gris uniformes. \
\
\>", "Text"],

Cell[CellGroupData[{

Cell["Filtro ideal de paso bajo", "Subsubsection"],

Cell[TextData[{
  "Se trata de un filtro que deja pasar todas las frecuencias por debajo de \
un umbral y elimina las restantes. Teniendo en cuenta c\[OAcute]mo est\
\[AAcute]n representadas las frecuencias en la transformada, un filtro de \
paso bajo ideal est\[AAcute] dado por una funci\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, v) = 1\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`D(u, v) < D\_0\%2\)]],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, v) = 0\)]],
  " en otro caso. Donde ",
  Cell[BoxData[
      \(TraditionalForm\`D(u, v)\)]],
  " es la distancia eucl\[IAcute]dea medida desde el origen de la \
transformada de Fourier que se supone centrada. De forma m\[AAcute]s expl\
\[IAcute]cita ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, v) = 1\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(\((u - M/2 - 1)\)\^2 + \((v - N/2 - 1)\)\^2\) < 
        D\_0\%2\)]],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, v) = 0\)]],
  " en otro caso. Donde hemos supuesto que las dimensiones de la imagen son \
",
  Cell[BoxData[
      \(TraditionalForm\`M\[Times]N\)]],
  ". La cantidad ",
  Cell[BoxData[
      \(TraditionalForm\`D\_0\)]],
  " es la frecuencia de corte. Este filtro deja pasar inalteradas todas las \
frecuencias en un c\[IAcute]rculo de radio ",
  Cell[BoxData[
      \(TraditionalForm\`D\_0\)]],
  " y elimina totalmente todas las frecuencias fuera de dicho \
c\[IAcute]rculo. Este comportamiento no puede lograrse con circuitos electr\
\[OAcute]nicos, de ah\[IAcute] su nombre \"ideal\", aunque s\[IAcute] puede \
implementarse en un ordenador. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell["\<\
a) Define un comando \"filtroidealpasobajo[d][M,N]\" donde \"d\" es la \
frecuencia de corte y M, N son las dimensiones de la imagen (matriz) que \
proporcione el filtro ideal de paso bajo antes descrito.
b) Considera la siguiente imagen:\
\>", "ExerciseText"],

Cell[BoxData[{
    \(\(candado = Import["\<candado.dat\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[candado, 
        ImageSize \[Rule] {232, 154}];\)\), "\[IndentingNewLine]", 
    \(Dimensions[candado]\)}], "Input"],

Cell["\<\
Representa con Show[GraphicsArray[ ]] la imagen obtenida al aplicar el filtro \
ideal de paso bajo a la imagen anterior con frecuencias de corte d=4,5,6,7. \
\
\>", "ExerciseText"],

Cell[TextData[{
  "Observa el t\[IAcute]pico efecto de ",
  StyleBox["anillado",
    FontSlant->"Italic"],
  " que produce este filtro. Podemos explicar este efecto considerando el \
filtrado espacial por convoluci\[OAcute]n correspondiente a este filtro en \
frecuencia. Consideremos el siguiente caso."
}], "Text"],

Cell[BoxData[{
    \(\(H = \(filtroidealpasobajo[4]\)[154, 
          232];\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[H, ImageSize \[Rule] {232, 154}];\)\)}], "Input"],

Cell["\<\
c) Obt\[EAcute]n la funci\[OAcute]n impulsiva del correspondiente filtro \
espacial repres\[EAcute]ntala gr\[AAcute]ficamente. No olvides centrar las \
matrices respectivas. Deben aparecer unos anillos bien definidos. Representa \
tambi\[EAcute]n la funci\[OAcute]n impulsiva (centrada) con ListPlot3D[ ].\
\>", "ExerciseText"],

Cell[TextData[{
  "d) Define una imagen elemental de tama\[NTilde]o 154\[Times]232 formada \
por 5 niveles positivos de gris (que debes situar en puntos \
sim\[EAcute]tricos respecto al lugar central) y los dem\[AAcute]s nulos. \
Calcula la convoluci\[OAcute]n c\[IAcute]clica de la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "(la respuesta impulsiva del filtro) con la imagen elemental anterior y \
representa la imagen obtenida en este proceso de filtrado espacial. \
\[DownQuestion]Cu\[AAcute]l es el efecto de la convoluci\[OAcute]n? \
\[DownQuestion]Sabes explicar el efecto de anilllado que se observa al usar \
un filtro ideal de paso bajo?"
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtro gausiano de paso bajo", "Subsubsection"],

Cell["\<\
El siguiente comando muestrea una funci\[OAcute]n y permite elegir el n\
\[UAcute]mero de muestras en cada eje.\
\>", "Text"],

Cell[BoxData[
    \(samples[f_, {a_, b_}, {c_, d_}, {m_, n_}] := 
      Outer[f, Range[N[a], N[b - \(b - a\)\/m], N[\(b - a\)\/m]], 
        Range[N[c], N[d - \(d - c\)\/n], N[\(d - c\)\/n]]]\)], "Input"],

Cell[TextData[{
  "Podemos costruir un filtro de paso bajo con una gausiana. Estos filtros \
son de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, 
          v) = \[ExponentialE]\^\(\(-\(\(D\^2\)(u, v)\)\)/2  D\_0\%2\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`D(u, v)\)]],
  " es la distancia eucl\[IAcute]dea medida desde el origen de la \
transformada de Fourier que se supone centrada. El n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`D\_0\)]],
  " es la frecuencia de corte del filtro. Este filtro no elimina totalmente \
las frecuencias mayores que ",
  Cell[BoxData[
      \(TraditionalForm\`D\_0\)]],
  " ni tampoco deja pasar inalteradas las frecuencias menores; lo que hace es \
disminuir las frecuencias de forma proporcional a su distancia al centro de \
la transformada."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell["\<\
a) Define un comando \"filtrogausianopasobajo[d_][P_,Q_]\" que implementa un \
filtro gausiano de paso bajo con frecuencia de corte \"d\" para una imagen de \
dimensiones P\[Times]Q. Usa Chop[ ] para evitar n\[UAcute]meros demasiado \
peque\[NTilde]os.\
\>", "ExerciseText"],

Cell["\<\
b) Representa con Show[GraphicsArray[ ]] la imagen obtenida al aplicar el \
filtro gausiano de paso bajo a la imagen anterior (candado) con frecuencias \
de corte d=5,6,7,8. 
Observa que se han perdido casi totalmente los perfiles y la imagen ha \
quedado reducida a unas pocas zonas planas con tonalidades de gris uniforme. \
Adem\[AAcute]s no se produce efecto de anillado. Esto se debe a que este \
filtro no introduce una discontinuidad brusca como hace el filtro ideal de \
paso bajo. \
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtros de paso alto", "Subsubsection"],

Cell[TextData[{
  "Lo contrario de un filtro de paso bajo es uno de paso alto que solamente \
deja pasar las frecuencias altas, con el resultado de que acent\[UAcute]a los \
perfiles y los detalles finos de la imagen. Es f\[AAcute]cil convertir un \
filtro de paso bajo en uno de paso alto: si ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " es un filtro de paso bajo, ",
  Cell[BoxData[
      \(TraditionalForm\`Max[F] - F\)]],
  " es un filtro de paso alto (podemos decir que es su \"filtro \
complementario\"). Puedes comprobarlo ejecutando el siguiente comando."
}], "Text"],

Cell[BoxData[{
    \(\(graf[k_] := 
        filtrogeneral[candado, 1 - \(filtrogausianopasobajo[k]\)[154, 232], 
          ImageSize \[Rule] {232, 154}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{{graf[4], graf[6]}, {graf[8], graf[10]}}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] 2*{232, 154}];\)\)}], "Input"],

Cell["\<\
Ahora se han perdido tonalidades de gris pero los perfiles de la imagen se \
muestran n\[IAcute]tidos. Esto se aprecia mucho mejor con la siguiente \
imagen.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 96, 2, 174, "Title"],

Cell[CellGroupData[{
Cell[1875, 57, 41, 0, 93, "Section"],
Cell[1919, 59, 181, 4, 67, "Text"],
Cell[2103, 65, 693, 14, 254, "Input",
  InitializationCell->True],
Cell[2799, 81, 174, 3, 146, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3010, 89, 65, 0, 93, "Section"],
Cell[3078, 91, 1409, 43, 93, "Text"],
Cell[4490, 136, 933, 21, 85, "NumberedEquation"],
Cell[5426, 159, 2066, 68, 147, "Text"],
Cell[7495, 229, 82, 1, 41, "Text"],
Cell[7580, 232, 866, 20, 88, "NumberedEquation"],
Cell[8449, 254, 1311, 42, 94, "Text"],
Cell[9763, 298, 328, 9, 41, "Text"],

Cell[CellGroupData[{
Cell[10116, 311, 59, 0, 78, "Subsection"],
Cell[10178, 313, 295, 7, 67, "Text"],
Cell[10476, 322, 949, 22, 85, "NumberedEquation"],
Cell[11428, 346, 620, 14, 100, "Text"],

Cell[CellGroupData[{
Cell[12073, 364, 31, 0, 68, "Exercise"],
Cell[12107, 366, 1338, 30, 359, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13494, 402, 58, 0, 78, "Subsection"],
Cell[13555, 404, 661, 18, 93, "Text"],
Cell[14219, 424, 659, 16, 84, "NumberedEquation"],
Cell[14881, 442, 122, 3, 41, "Text"],
Cell[15006, 447, 1413, 37, 85, "NumberedEquation"],

Cell[CellGroupData[{
Cell[16444, 488, 31, 0, 68, "Exercise"],
Cell[16478, 490, 697, 14, 179, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17224, 510, 66, 0, 78, "Subsection"],
Cell[17293, 512, 647, 19, 93, "Text"],
Cell[17943, 533, 200, 5, 39, "Text"],
Cell[18146, 540, 555, 15, 93, "Text"],
Cell[18704, 557, 524, 17, 35, "NumberedEquation"],
Cell[19231, 576, 369, 9, 67, "Text"],

Cell[CellGroupData[{
Cell[19625, 589, 31, 0, 68, "Exercise"],
Cell[19659, 591, 1461, 31, 265, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21181, 629, 100, 2, 93, "Section"],
Cell[21284, 633, 561, 9, 119, "Text"],

Cell[CellGroupData[{
Cell[21870, 646, 31, 0, 68, "Exercise"],
Cell[21904, 648, 992, 15, 239, "ExerciseText"],
Cell[22899, 665, 139, 2, 98, "Input"],
Cell[23041, 669, 341, 6, 93, "ExerciseText"],
Cell[23385, 677, 262, 6, 124, "Input"],
Cell[23650, 685, 300, 5, 67, "ExerciseText"],
Cell[23953, 692, 130, 3, 41, "ExerciseText"],
Cell[24086, 697, 267, 4, 124, "Input"],
Cell[24356, 703, 285, 4, 150, "Input"],
Cell[24644, 709, 290, 5, 124, "Input"],
Cell[24937, 716, 521, 8, 119, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25507, 730, 78, 0, 93, "Section"],
Cell[25588, 732, 1593, 49, 182, "Text"],
Cell[27184, 783, 529, 10, 93, "Text"],
Cell[27716, 795, 231, 4, 35, "Text"],
Cell[27950, 801, 498, 11, 93, "Text"],
Cell[28451, 814, 326, 5, 150, "Input"],
Cell[28780, 821, 484, 14, 68, "Text"],
Cell[29267, 837, 427, 8, 48, "Text"],
Cell[29697, 847, 1018, 25, 186, "Text"],

Cell[CellGroupData[{
Cell[30740, 876, 31, 0, 68, "Exercise"],
Cell[30774, 878, 1002, 21, 205, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31813, 904, 54, 0, 78, "Subsection"],
Cell[31870, 906, 649, 10, 145, "Text"],

Cell[CellGroupData[{
Cell[32544, 920, 50, 0, 67, "Subsubsection"],
Cell[32597, 922, 1662, 43, 223, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34296, 970, 31, 0, 68, "Exercise"],
Cell[34330, 972, 270, 5, 101, "ExerciseText"],
Cell[34603, 979, 230, 4, 146, "Input"],
Cell[34836, 985, 190, 4, 67, "ExerciseText"],
Cell[35029, 991, 316, 7, 67, "Text"],
Cell[35348, 1000, 178, 3, 98, "Input"],
Cell[35529, 1005, 337, 5, 93, "ExerciseText"],
Cell[35869, 1012, 791, 16, 145, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36697, 1033, 53, 0, 67, "Subsubsection"],
Cell[36753, 1035, 135, 3, 41, "Text"],
Cell[36891, 1040, 204, 3, 176, "Input"],
Cell[37098, 1045, 837, 20, 150, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37972, 1070, 31, 0, 68, "Exercise"],
Cell[38006, 1072, 284, 5, 67, "ExerciseText"],
Cell[38293, 1079, 522, 9, 153, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38852, 1093, 45, 0, 67, "Subsubsection"],
Cell[38900, 1095, 585, 12, 119, "Text"],
Cell[39488, 1109, 407, 7, 150, "Input"],
Cell[39898, 1118, 181, 4, 67, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

